' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Data
Imports System.Data.SqlClient
Imports System.Security

Public Class BookingObjectManagerDB

  ''' <summary>
  ''' Ukryj konstruktor, aby unikn tworzenia egzemplarzy klasy BookingObjectManagerDB.
  ''' </summary>
  Private Sub New()
  End Sub

  ''' <summary>
  ''' Zwraca list of dostpnymi obiektami rezerwacji jako DataSet wykonujc zapytanie do bazy danych.
  ''' </summary>
  ''' <returns>DataSet z dostpnymi obiektami rezerwacji zawierajcy dwie kolumny: identyfikator i nazw dla kadego obiektu rezerwacji.</returns>
  Public Shared Function GetBookingObjectList() As DataSet
    Dim myDataSet As DataSet = New DataSet()

    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)
        Dim myCommand As SqlCommand = New SqlCommand("sprocBookingObjectselectList", myConnection)
        myCommand.CommandType = CommandType.StoredProcedure

        Dim myDataAdapter As SqlDataAdapter = New SqlDataAdapter()
        myDataAdapter.SelectCommand = myCommand
        myDataAdapter.Fill(myDataSet)
        myConnection.Close()
        Return myDataSet
      End Using
    Catch ex As Exception
      ' Przepu bd; zostanie przechwycony przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
      Throw
    End Try
  End Function

  ''' <summary>
  ''' Zwraca pojedynczy obiekt rezerwacji na podstawie jego identyfikatora wykonujc zapytanie do bazy danych.
  ''' </summary>
  ''' <param name="id">Identyfikator obiektu rezerwacji w bazie danych.</param>
  ''' <returns>dany obiekt rezerwacji lub <see langword="null" /> jeli nie mona bylo znale pozycji w bazie danych.</returns>
  Public Shared Function GetBookingObject(ByVal id As Integer) As BookingObject
    Dim myBookingObject As BookingObject = Nothing

    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)
        Dim myCommand As SqlCommand = New SqlCommand("sprocBookingObjectselectSingleItem", myConnection)
        myCommand.CommandType = CommandType.StoredProcedure

        myCommand.Parameters.AddWithValue("@id", id)

        myConnection.Open()
        Using myReader As SqlDataReader = _
              myCommand.ExecuteReader(CommandBehavior.CloseConnection)
          If myReader.Read() Then
            myBookingObject = New BookingObject()
            myBookingObject.Id = myReader.GetInt32(myReader.GetOrdinal("Id"))
            myBookingObject.Title = myReader.GetString(myReader.GetOrdinal("Title"))
            myBookingObject.StartTime = Convert.ToDateTime(myReader.GetValue(myReader.GetOrdinal("StartTime"))).Hour
            myBookingObject.EndTime = Convert.ToDateTime(myReader.GetValue(myReader.GetOrdinal("EndTime"))).Hour
          End If
          myReader.Close()

          If myBookingObject IsNot Nothing Then
            ' Pobierz dostpne dni robocze zwizane z tym obiektem rezerwacji
            myCommand = New SqlCommand("sprocBookingObjectselectWeekdays", myConnection)
            myCommand.CommandType = CommandType.StoredProcedure
            myCommand.Parameters.AddWithValue("@id", id)
            myConnection.Open()
            Using myWeekdayReader As SqlDataReader = _
                  myCommand.ExecuteReader(CommandBehavior.CloseConnection)
              ' Ustaw flagi dla wybranych dni tygodnia
              While myWeekdayReader.Read()
                Select Case myWeekdayReader.GetInt32(0)
                  Case 1
                    myBookingObject.AvailableOnWeekdays = myBookingObject.AvailableOnWeekdays Or Weekdays.Sunday
                  Case 2
                    myBookingObject.AvailableOnWeekdays = myBookingObject.AvailableOnWeekdays Or Weekdays.Monday
                  Case 3
                    myBookingObject.AvailableOnWeekdays = myBookingObject.AvailableOnWeekdays Or Weekdays.Tuesday
                  Case 4
                    myBookingObject.AvailableOnWeekdays = myBookingObject.AvailableOnWeekdays Or Weekdays.Wednesday
                  Case 5
                    myBookingObject.AvailableOnWeekdays = myBookingObject.AvailableOnWeekdays Or Weekdays.Thursday
                  Case 6
                    myBookingObject.AvailableOnWeekdays = myBookingObject.AvailableOnWeekdays Or Weekdays.Friday
                  Case 7
                    myBookingObject.AvailableOnWeekdays = myBookingObject.AvailableOnWeekdays Or Weekdays.Saturday
                End Select
              End While
            End Using
          End If
        End Using
      End Using
    Catch
      Throw
    Finally
    End Try
    Return myBookingObject
  End Function

  ''' <summary>
  ''' Zapisuje nowy lub istniejcy obiekt rezerwacji w bazie danych wykonujc procedur skadowan.
  ''' </summary>
  ''' <param name="myBookingObject">Obiekt rezerwacji, ktry ma by zapisany. Jeli <see cref="BookingObject.Id" /> wynosi -1, nowa pozycja jest tworzona, w przeciwnym razie istniejcy egzemplarz jest aktualizowany.</param>
  Public Shared Sub SaveBookingObject(ByVal myBookingObject As BookingObject)
    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)
        Dim myCommand As SqlCommand = New SqlCommand("sprocBookingObjectInsertUpdateSingleItem", myConnection)
        myCommand.CommandType = CommandType.StoredProcedure

        Dim myDataAdapter As SqlDataAdapter = New SqlDataAdapter()
        myDataAdapter.SelectCommand = myCommand

        If myBookingObject.Id = -1 Then
          myCommand.Parameters.AddWithValue("@id", DBNull.Value)
        Else
          myCommand.Parameters.AddWithValue("@id", myBookingObject.Id)
        End If

        myCommand.Parameters.AddWithValue("@title", myBookingObject.Title)
        myCommand.Parameters.AddWithValue("@startTime", myBookingObject.StartTime)
        myCommand.Parameters.AddWithValue("@endTime", myBookingObject.EndTime)

        ' Dodaj warto logiczn dla kadego dnia tygodnia we waciwoci AvailableOnWeekdays.
        myCommand.Parameters.AddWithValue("@sunday", Convert.ToBoolean(myBookingObject.AvailableOnWeekdays And Weekdays.Sunday))
        myCommand.Parameters.AddWithValue("@monday", Convert.ToBoolean(myBookingObject.AvailableOnWeekdays And Weekdays.Monday))
        myCommand.Parameters.AddWithValue("@tuesday", Convert.ToBoolean(myBookingObject.AvailableOnWeekdays And Weekdays.Tuesday))
        myCommand.Parameters.AddWithValue("@wednesday", Convert.ToBoolean(myBookingObject.AvailableOnWeekdays And Weekdays.Wednesday))
        myCommand.Parameters.AddWithValue("@thursday", Convert.ToBoolean(myBookingObject.AvailableOnWeekdays And Weekdays.Thursday))
        myCommand.Parameters.AddWithValue("@friday", Convert.ToBoolean(myBookingObject.AvailableOnWeekdays And Weekdays.Friday))
        myCommand.Parameters.AddWithValue("@saturday", Convert.ToBoolean(myBookingObject.AvailableOnWeekdays And Weekdays.Saturday))

        myConnection.Open()
        myCommand.ExecuteNonQuery()
        myConnection.Close()

      End Using
    Catch ex As Exception
      ' Przepu bd; zostanie przechwycony przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
      Throw
    End Try
  End Sub

  ''' <summary>
  ''' Zwraca list with dostpnych dni roboczych wykonujc zapytanie do bazy danych.
  ''' </summary>
  ''' <returns>DataSet z dostpnymi dniami roboczymi zawierajcy dwie kolumny: identyfikator i opis dnia roboczego.</returns>
  Public Shared Function GetWorkingDays() As DataSet
    Dim myDataSet As DataSet = New DataSet()
    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)
        Dim myCommand As SqlCommand = New SqlCommand("sprocWorkingDaysSelectList", myConnection)
        myCommand.CommandType = CommandType.StoredProcedure

        Dim myDataAdapter As SqlDataAdapter = New SqlDataAdapter()
        myDataAdapter.SelectCommand = myCommand
        myDataAdapter.Fill(myDataSet)
        myConnection.Close()

        Return myDataSet
      End Using
    Catch ex As Exception
      ' Przepu bd; zostanie przechwycony przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
      Throw
    End Try

  End Function

End Class
